/*
 * Decompiled with CFR 0.152.
 */
package wox.serial;

public class EncodeBase64 {
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_CHAR = 61;
    private static final byte NEW_LINE_CHAR = 10;
    private static final byte[] TABLE64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] DECODE_TABLE64 = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    public static byte[] encode(byte[] source) {
        int len = source.length;
        boolean off = false;
        boolean options = false;
        int newLen = len * 4 / 3;
        int padding = 0;
        if (len % 3 == 1) {
            padding = 3;
        }
        if (len % 3 == 2) {
            padding = 2;
        }
        int breaks = newLen / 76;
        int finalSize = newLen + padding + breaks;
        byte[] encodedArray = new byte[finalSize];
        int i = 0;
        int j = 0;
        int len2 = len - 2;
        int lineLength = 0;
        i = 0;
        while (i < len2) {
            EncodeBase64.encode3Bytes(source, i, 3, encodedArray, j);
            if ((lineLength += 4) == 76) {
                encodedArray[j + 4] = 10;
                ++j;
                lineLength = 0;
            }
            i += 3;
            j += 4;
        }
        if (i < len) {
            EncodeBase64.encode3Bytes(source, i, len - i, encodedArray, j);
            j += 4;
        }
        return encodedArray;
    }

    private static void encode3Bytes(byte[] source, int sourceOff, int numBytes, byte[] target, int targetOff) {
        int result = (numBytes > 0 ? source[sourceOff] << 24 >>> 8 : 0) | (numBytes > 1 ? source[sourceOff + 1] << 24 >>> 16 : 0) | (numBytes > 2 ? source[sourceOff + 2] << 24 >>> 24 : 0);
        switch (numBytes) {
            case 3: {
                target[targetOff] = TABLE64[result >>> 18];
                target[targetOff + 1] = TABLE64[result >>> 12 & 0x3F];
                target[targetOff + 2] = TABLE64[result >>> 6 & 0x3F];
                target[targetOff + 3] = TABLE64[result & 0x3F];
                break;
            }
            case 2: {
                target[targetOff] = TABLE64[result >>> 18];
                target[targetOff + 1] = TABLE64[result >>> 12 & 0x3F];
                target[targetOff + 2] = TABLE64[result >>> 6 & 0x3F];
                target[targetOff + 3] = 61;
                break;
            }
            case 1: {
                target[targetOff] = TABLE64[result >>> 18];
                target[targetOff + 1] = TABLE64[result >>> 12 & 0x3F];
                target[targetOff + 2] = 61;
                target[targetOff + 3] = 61;
            }
        }
    }

    public static byte[] decode(byte[] source) {
        int len = source.length;
        int len34 = len * 3 / 4;
        byte[] targetArray = new byte[len34];
        int targetIndex = 0;
        byte[] aux = new byte[4];
        int auxPos = 0;
        int i = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        for (i = 0; i < len; ++i) {
            sbiCrop = (byte)(source[i] & 0x7F);
            sbiDecode = DECODE_TABLE64[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                aux[auxPos++] = sbiCrop;
                if (auxPos <= 3) continue;
                targetIndex += EncodeBase64.decode4Bytes(aux, 0, targetArray, targetIndex);
                auxPos = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            System.err.println("Bad Base64 input character at " + i + ": " + source[i] + "(decimal)");
            return null;
        }
        byte[] out = new byte[targetIndex];
        System.arraycopy(targetArray, 0, out, 0, targetIndex);
        return out;
    }

    private static int decode4Bytes(byte[] source, int sourceOff, byte[] target, int targetOff) {
        if (source[sourceOff + 2] == 61) {
            int result = (DECODE_TABLE64[source[sourceOff]] & 0xFF) << 18 | (DECODE_TABLE64[source[sourceOff + 1]] & 0xFF) << 12;
            target[targetOff] = (byte)(result >>> 16);
            return 1;
        }
        if (source[sourceOff + 3] == 61) {
            int result = (DECODE_TABLE64[source[sourceOff]] & 0xFF) << 18 | (DECODE_TABLE64[source[sourceOff + 1]] & 0xFF) << 12 | (DECODE_TABLE64[source[sourceOff + 2]] & 0xFF) << 6;
            target[targetOff] = (byte)(result >>> 16);
            target[targetOff + 1] = (byte)(result >>> 8);
            return 2;
        }
        try {
            int result = (DECODE_TABLE64[source[sourceOff]] & 0xFF) << 18 | (DECODE_TABLE64[source[sourceOff + 1]] & 0xFF) << 12 | (DECODE_TABLE64[source[sourceOff + 2]] & 0xFF) << 6 | DECODE_TABLE64[source[sourceOff + 3]] & 0xFF;
            target[targetOff] = (byte)(result >> 16);
            target[targetOff + 1] = (byte)(result >> 8);
            target[targetOff + 2] = (byte)result;
            return 3;
        }
        catch (Exception e) {
            System.out.println("" + source[sourceOff] + ": " + DECODE_TABLE64[source[sourceOff]]);
            System.out.println("" + source[sourceOff + 1] + ": " + DECODE_TABLE64[source[sourceOff + 1]]);
            System.out.println("" + source[sourceOff + 2] + ": " + DECODE_TABLE64[source[sourceOff + 2]]);
            System.out.println("" + source[sourceOff + 3] + ": " + DECODE_TABLE64[source[sourceOff + 3]]);
            return -1;
        }
    }

    public static void main(String[] args) {
        System.out.println("\nTesting Base64...");
        byte[] source = new byte[]{97, 104, 44, 113, 81, 89, 41, 91, 100, 55, 44, 119, 70, 55, 48, 93, 53, 47, 110, 101, 72, 48, 123, 42, 116, 47, 98, 114, 51, 49, 43, 117, 103, 113, 118, 103, 64, 33, 43, 121, 104, 35, 99, 117, 106, 34, 112, 116, 56, 101, 100, 105, 46, 36, 108, 102, 105, 103, 116, 111, -95, 37, 111, 56, 63, 54, 54, 61, -65, 38, 111, 48, 111, 56, 55, 63, 41, 40, 106, -15, 97, 104, 44, 113, 81, 89, 41, 91, 100, 55, 44, 119, 70, 55, 48, 93, 53, 47, 110, 101, 72, 48, 123, 42, 116, 47, 98, 114, 51, 49, 43, 117, 103, 113, 118, 103, 64, 33, 43, 121, 104, 35, 99, 117, 106, 34, 112, 116, 56, 101, 100, 105, 46, 36, 108, 102, 105, 103, 116, 111, -95, 37, 111, 56, 63, 54, 54, 61, -65, 38, 111, 48, 111, 56, 55, 63, 41, 40, 106, -15, 109};
        String strSource = new String(source);
        System.out.println("\nThe source array size is: " + source.length + ", and it is:\n" + strSource);
        System.out.println("-------------------------------------------------------------------------------------------------------");
        System.out.println("\nEncoding...");
        byte[] target = EncodeBase64.encode(source);
        String strTarget = new String(target);
        System.out.println("The encoded array size is: " + target.length + ", and it is:\n" + strTarget);
        System.out.println("-------------------------------------------------------------------------------------------------------");
        System.out.println("\nDecoding...");
        byte[] decodedArray = EncodeBase64.decode(target);
        String strDecodedArray = new String(decodedArray);
        System.out.println("The decoded array is: " + decodedArray.length + ", and it \n" + strDecodedArray);
        System.out.println("-------------------------------------------------------------------------------------------------------");
    }
}

